# Generated Python Strategy for: gpt-4o-2024-08-06 (gpt_4o_2024_08_06_InitialAgent)
# LLM API: openai, Model: gpt-4o
# Based on: gpt_4o_2024_08_06_InitialAgent_strategy.txt
# Effective Fallback: C

def gpt_4o_2024_08_06_InitialAgent(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    import random

    # Constants
    COOPERATE = "C"
    DEFECT = "D"
    FORGIVENESS_PROBABILITY = 0.1
    EXPLOITATION_THRESHOLD = 0.3

    # Initial Moves
    if len(my_history) < 3:
        return COOPERATE

    # Tit-for-Tat with Forgiveness
    if opp_history[-1] == DEFECT:
        if random.random() < FORGIVENESS_PROBABILITY:
            return COOPERATE
        else:
            return DEFECT
    else:
        return COOPERATE

    # Exploitation Detection
    cooperation_rate = opp_history.count(COOPERATE) / len(opp_history)
    if cooperation_rate < EXPLOITATION_THRESHOLD:
        return DEFECT

    # Adaptation to Opponent Program Code
    if "defect" in opponent_program_code.lower():
        return DEFECT
    if "cooperate" in opponent_program_code.lower():
        return DEFECT if random.random() < 0.5 else COOPERATE

    # Self-Play Consideration
    if opponent_program_code == __file__:
        return COOPERATE

    # Default Fallback Move
    return COOPERATE